k6 `v1.0.0-rc1` is here 🎉!

This release marks a special, non-conventional milestone in the k6 software life-cycle, serving as a preview of the upcoming version 1.0.0.

The purpose of this release is to give the community a chance to test the new version, identify any potential issues, and test migrations of any parts affected by breaking changes. If you encounter any problems or have trouble with the migration, we encourage you to report them by creating an issue. Your feedback will help improve the final release. If no critical issues are reported, we plan to release the final `v1.0.0` within the next month.

Here’s a glimpse of what’s new in this release:

- `k6/experimental/webcrypto` promoted to stable and available globally under `crypto`.
- A revamped end-of-test summary aiming to bring an easier way to understand test results.
- `k6/browser` provided an API for tracking network requests and responses.
- The new `k6/secrets` module for retrieving secrets with extension support.

## Breaking changes

- [#4541](https://github.com/grafana/k6/pull/4541) Commas(`,`) are now supported in the values of the `--tag` CLI flag. This is a breaking change, as previously, a comma meant the start of a new set of tag-values. As a comma is a valid symbol for the value of a tag, this is necessary to have equivalency between different ways of setting tags. This still allows multiple tags to be set on the CLI with multiple `--tag key=value` arguments.

### A new default path for the configuration file [#4301](https://github.com/grafana/k6/pull/4301)

When running the `k6 cloud login` or the deprecated `k6 login` commands, a configuration file was automatically created at `{USER_CONFIG_DIR}/loadimpact/config.json`. Now, the configuration file is created at `{USER_CONFIG_DIR}/k6/config.json`.

To migrate your configuration file to the new path:

1. Run `k6 cloud login` or `k6 login` to automatically migrate the configuration file to the new location.
2. Run `k6 cloud run` or `k6 run` to verify that the version is now fully functional and no related warning is emitted.

The configuration file in the old path remains available and can continue to be used with the previous k6 versions. If you're not using an old version of k6 anymore, consider deleting the files manually.

The `k6 run` commands search for the configuration file in the new location. If it can't find it, it tries to fall back on the old path and then logs a warning message suggesting to migrate it.

## New features

### A revamped end-of-test summary aiming to bring an easier way to understand test results [#4089](https://github.com/grafana/k6/pull/4089), [#4649](https://github.com/grafana/k6/pull/4649)

The end-of-test-summary has been revamped to make it easier for users to understand test results. That includes:
- A new format to summarize the results of the user-defined [Checks](https://grafana.com/docs/k6/latest/using-k6/checks/) and [Thresholds](https://grafana.com/docs/k6/latest/using-k6/thresholds/).
- Now metrics are split into different sections, making it easier to focus on what really matters.

![End of test summary example](https://github.com/user-attachments/assets/68036748-f7be-45e1-b69a-65fa18c458ee)

The new end-of-test summary is enabled by default for users, but you can use the `summary-mode` flag to choose between different modes:
- `compact` *(default)*: what you can see in the example above, with the most relevant information.
- `full`: similar to `compact`, but also includes some more detailed metrics and results for each [group](https://grafana.com/docs/k6/latest/using-k6/tags-and-groups/#groups) and [scenario](https://grafana.com/docs/k6/latest/using-k6/scenarios/) defined in the test. 
- `legacy`: the old summary format for backward compatibility.

> Note: The data structure received by the [`handleSummary`](https://grafana.com/docs/k6/latest/results-output/end-of-test/custom-summary/) function, 
> as well as the data exported using `--summary-export`, has not changed in this release. However, these may change in upcoming releases, which could introduce breaking changes.

### Browser: Tracking network requests and responses [#4290](https://github.com/grafana/k6/issues/4290), [#4296](https://github.com/grafana/k6/issues/4296)

The [browser module](https://grafana.com/docs/k6/latest/javascript-api/k6-browser/) adds support for tracking network requests and responses. This feature is especially useful for validating certain aspects of the requests and responses to determine whether the test was successful. It can also be used to debug issues with the test script or the tested application. Refer to the [documentation](https://grafana.com/docs/k6/latest/javascript-api/k6-browser/page/on/) for more details.

For example, to track all requests and responses made by a page, you can use the following script:

```javascript
import { browser } from 'k6/browser';

export const options = {
  scenarios: {
    ui: {
      executor: 'shared-iterations',
      options: {
        browser: {
          type: 'chromium',
        },
      },
    },
  },
};

export default async function () {
  const page = await browser.newPage();

  // registers a handler that logs all requests made by the page
  page.on('request', async request => console.log(request.url()));
  // registers a handler that logs all responses received by the page
  page.on('response', async response => console.log(response.url()));

  await page.goto('https://quickpizza.grafana.com/', { waitUntil: 'networkidle' });
  await page.close();
}
```

The output might look like this:

```bash
INFO[0000] https://quickpizza.grafana.com/                  source=console
INFO[0001] https://quickpizza.grafana.com/api/tools         source=console
INFO[0001] https://quickpizza.grafana.com/images/pizza.png  source=console
...
```

### `k6/experimental/webcrypto` promoted to stable and available globally under `crypto` [#4278](https://github.com/grafana/k6/pull/4278)

With this release, the `k6/experimental/webcrypto` module is promoted to stable and available globally under `crypto`. That means you can remove the `import { crypto } from 'k6/experimental/webcrypto';` statement from your scripts and still use the module. 

```javascript
export default function () {
  const myUUID = crypto.randomUUID();

  console.log(myUUID);
}
```

`k6/experimental/webcrypto` is deprecated and will be removed in `v1.1.0`.

### Support for custom templates in `k6 new` command [#4618](https://github.com/grafana/k6/pull/4618)

The `k6 new` command now accepts a path to a file to use as a template for the new script. Templates use [Go templates syntax](https://pkg.go.dev/text/template#pkg-overview) and can include the following variables:

- `ScriptName`: The name of the new script.
- `ProjectID`: The ID of the Grafana Cloud project to use for the new script.

To generate a new script using a custom template, use the following command:

```sh
k6 new --template /path/to/my-template.js
```

### Secret Sources [#4514](https://github.com/grafana/k6/pull/4514), [#4621](https://github.com/grafana/k6/pull/4621), [#4637](https://github.com/grafana/k6/pull/4637)

We've added support for retrieving secrets from different sources. Among other things, this means that the values received from a secret source will be redacted from the logs. Refer to the [documentation](https://grafana.com/docs/k6/latest/using-k6/secret-source) for more details.

The two implementations available are to read secrets from a key-value file or from CLI flags, which are meant mostly to test the feature. We've also included extension support, which can be used to implement retrieving secrets from more secure sources.

In the future, we'll likely include additional implementations that are more production-ready.

Here's an example where we log the secret directly, make a request, and then log the whole response. In both cases, the secrets are redacted from the logs.

```javascript
import http from 'k6/http';
import secrets from 'k6/secrets';

export default async () => {
  const my_secret = await secrets.get('cool'); // get secret from a source with the provided identifier
  console.log(my_secret);
  const response = await http.asyncRequest("GET", "https://httpbin.org/get", null, {
    headers: {
      "Custom-Authentication": `Bearer ${await secrets.get("else")}`,
    }
  })
  console.log(response.body)
}
```

```shell
$ k6 run --secret-source=mock=cool="not cool secret",else="totally a secret" script.js
...
INFO[0000] ***SECRET_REDACTED***                         source=console
INFO[0031] {
  "args": {},
  "headers": {
    "Custom-Authentication": "Bearer ***SECRET_REDACTED***",
    "Host": "httpbin.org",
    "User-Agent": "k6/1.0.0-rc1 (https://k6.io/)",
    "X-Amzn-Trace-Id": "Root=1-67dd6691-18eeaf5d1782bf292da5037c"
  },
  "origin": "1.1.1.1",
  "url": "https://httpbin.org/get"
}  source=console
...
```

## UX improvements and enhancements

- [#4547](https://github.com/grafana/k6/pull/4547) The k6 banner now outputs with the original TrueColor (24-bit) logo only if the terminal supports it.
- [#4590](https://github.com/grafana/k6/pull/4590) Moves the `docker-compose` example with InfluxDB to the `examples/docker-compose` directory and adds an opentelemetry example.
- [#4602](https://github.com/grafana/k6/pull/4602), [#4629](https://github.com/grafana/k6/pull/4629) Improves the error message on options error from script. k6 now will try to print the part of the options that fails as JSON.
- [#4612](https://github.com/grafana/k6/pull/4612) Updates the link included in the local modules' error message. Thanks, @tanurrra!

## Bug fixes

- [#4544](https://github.com/grafana/k6/pull/4544) Fixes race in `ReadableStream.cancel` and run WPT test with race detection for easier finding of similar problems.
- [#4567](https://github.com/grafana/k6/pull/4567), [#4558](https://github.com/grafana/k6/pull/4558), [#4574](https://github.com/grafana/k6/pull/4574), [#4610](https://github.com/grafana/k6/pull/4610) Fixes race conditions with the browser module's `ElementHandle`, `Mouse`, `Keyboard`, and `Response`.
- [#4641](https://github.com/grafana/k6/pull/4641) Fixes JSON marshalling of tagset. Thank you @dvordrova 🙇.

## Maintenance and internal improvements

- [#4519](https://github.com/grafana/k6/pull/4519), [#4562](https://github.com/grafana/k6/pull/4562) Moves the Prometheus remote write, and OpenTelemetry outputs' code to the k6 repository.
- [#4545](https://github.com/grafana/k6/pull/4545) Tries to stabilize MacOS CI by making browser throttle.js easier to run for it.
- [#4546](https://github.com/grafana/k6/pull/4546), [#4643](https://github.com/grafana/k6/pull/4643) Reduce flakiness of the test suite.
- [#4552](https://github.com/grafana/k6/pull/4552) Updates the fallback x509 certificates for CA roots.
- [#4561](https://github.com/grafana/k6/pull/4561), [#4638](https://github.com/grafana/k6/pull/4638) Update Sobek to fix a bug in `Function.apply`, logical assignment support, array destructuring in exports, better cross-os source map support.
- [#4563](https://github.com/grafana/k6/pull/4563) Fix `k6/timers` reporting as always being used.
- [#4603](https://github.com/grafana/k6/pull/4603) Homogenize package docs comment block format.
- [#4605](https://github.com/grafana/k6/pull/4605) Refactor the code responsible for `lib.RuntimeOptions` loading.
- [#4606](https://github.com/grafana/k6/pull/4606), [#4604](https://github.com/grafana/k6/pull/4604) Bump k6 to depend on greater or equal Go 1.23 versions, build with 1.24, then use a compatible golangci-lint version. 
- [#4611](https://github.com/grafana/k6/pull/4611) Extract the HDR histogram implementation into a shared package.
- [#4616](https://github.com/grafana/k6/pull/4616), [#4613](https://github.com/grafana/k6/pull/4613), [#4627](https://github.com/grafana/k6/pull/4627), [#4615](https://github.com/grafana/k6/pull/4615), [#4592](https://github.com/grafana/k6/pull/4592), [#4578](https://github.com/grafana/k6/pull/4578), [#4554](https://github.com/grafana/k6/pull/4554), [#4553](https://github.com/grafana/k6/pull/4553), [#4552](https://github.com/grafana/k6/pull/4552), [#4527](https://github.com/grafana/k6/pull/4527), [#4550](https://github.com/grafana/k6/pull/4550) Update direct dependencies.
- [#4639](https://github.com/grafana/k6/pull/4639) Pushes the `latest` docker image tag even for `rc` releases.
